
set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CMAKE_CURRENT_LIST_DIR})

option(CUDA_BUILD_CC20 "Build with compute capability 2.0 support" FALSE)
option(CUDA_BUILD_CC30 "Build with compute capability 3.0 support" FALSE)
option(CUDA_BUILD_CC35 "Build with compute capability 3.5 support" FALSE)
option(CUDA_BUILD_CC35_NODYN "Build with compute capability 3.5 support without dynamic parallelism" TRUE)
option(CUDA_BUILD_CC50 "Build with compute capability 5.0 support" FALSE)
option(CUDA_BUILD_CC50_NODYN "Build with compute capability 5.0 support without dynamic parallelism" FALSE)
option(CUDA_BUILD_INFO "Build with kernel statistics and line numbers" TRUE)
option(CUDA_BUILD_DEBUG "Build with kernel debug" FALSE)
option(CUDA_ENABLE_CUPTI_INSTRUMENTATION "enable CUPTI instrumentation" TRUE)

set(CUDA_NVCC_FLAGS "-use_fast_math;")
if(CUDA_BUILD_CC20)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-gencode=arch=compute_20,code=sm_20;")
endif()
if(CUDA_BUILD_CC30)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-gencode=arch=compute_30,code=sm_30;")
endif()
if(CUDA_BUILD_CC35 OR CUDA_BUILD_CC35_NODYN)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-gencode=arch=compute_35,code=sm_35;-maxrregcount=63;")
endif()
if(CUDA_BUILD_CC50)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-gencode=arch=compute_50,code=sm_50;")
endif()
if(CUDA_BUILD_CC50 OR CUDA_BUILD_CC50_NODYN)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-gencode=arch=compute_50,code=sm_50;-maxrregcount=63;")
endif()
if(CUDA_BUILD_INFO)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-keep;--ptxas-options=-v;-lineinfo")
endif()
if(CUDA_BUILD_DEBUG)
	set(CUDA_NVCC_FLAGS "${CUDA_NVCC_FLAGS};-G")
endif()

set(CUDA_ATTACH_VS_BUILD_RULE_TO_CUDA_FILE OFF CACHE BOOL "ATTACH")
if (WIN32)
	set(CUDA_PROPAGATE_HOST_FLAGS ON CACHE BOOL "ATTACH")
else ()
	set(CUDA_PROPAGATE_HOST_FLAGS OFF CACHE BOOL "ATTACH")
endif ()

if(CUDA_BUILD_CC35 OR CUDA_BUILD_CC50_NODYN)
	find_package(CUDA_DLINK REQUIRED)
else()
	find_package(CUDA REQUIRED)
endif()

if (NOT WIN32)
	set(CMAKE_CXX_FLAGS "-std=c++11") 
endif ()

include_directories(${CUDA_INCLUDE_DIRS})
include_directories(${GPUSchedulingRoot}/components/core)
